/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.util.maths;

import frc.emul.util.maths.CatmullRom;
import java.awt.geom.Point2D;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MathUtils {
    private MathUtils() {
    }

    public static void fillCatmullRom(List<Point2D.Float> list, float[] fArray, float f) {
        new CatmullRom().fill(list, fArray, f);
    }

    public static void fillCatmullRom(float f, Point2D.Float float_, Point2D.Float[] floatArray, float[] fArray) {
        int n = floatArray.length - 1;
        int n2 = 0;
        float f2 = fArray.length - 1;
        float f3 = 0.0f;
        float f4 = 0.0f;
        floatArray[0].y = 0.0f;
        floatArray[0].x = 0.0f;
        CatmullRom.adjustTangent(floatArray[0], floatArray[2], floatArray[2], floatArray[0]);
        floatArray[n].y = 1.0f;
        floatArray[n].x = 1.0f;
        CatmullRom.adjustTangent(floatArray[n - 2], floatArray[n], floatArray[n - 2], floatArray[n]);
        int n3 = 1;
        while (n3 < floatArray.length - 2) {
            float f5 = f;
            while (true) {
                int n4;
                MathUtils.computeCatmullRom(f5, floatArray, n3, float_);
                float f6 = float_.x * f2;
                float f7 = float_.y;
                if (f6 < 0.0f) {
                    f6 = 0.0f;
                } else if (f6 > f2) {
                    f6 = f2;
                }
                if (f7 < 0.0f) {
                    f7 = 0.0f;
                } else if (f7 > 1.0f) {
                    f7 = 1.0f;
                }
                if (f6 < f3) {
                    f6 = f3;
                }
                if (f7 < f4) {
                    f7 = f4;
                }
                if (n2 < (n4 = (int)f6)) {
                    float f8;
                    float f9 = f6 - f3;
                    float f10 = (f7 - f4) / f9;
                    float f11 = f8 = f9 / (float)((n4 - n2) * 3);
                    while (n2 < n4) {
                        int n5 = (int)(f3 + f11);
                        if (n5 > n2) {
                            fArray[++n2] = f4 + f10 * f11;
                        }
                        f11 += f8;
                    }
                }
                f3 = f6;
                f4 = f7;
                if (f5 >= 1.0f) break;
                if (!((f5 += f) > 1.0f)) continue;
                f5 = 1.0f;
            }
            ++n3;
        }
        fArray[0] = 0.0f;
        fArray[fArray.length - 1] = 1.0f;
    }

    public static final void computeCatmullRom(float f, Point2D.Float[] floatArray, int n, Point2D.Float float_) {
        float f2 = f * f;
        float f3 = f2 * f;
        float f4 = 2.0f * f2 - f3 - f;
        float f5 = 2.0f - 5.0f * f2 + 3.0f * f3;
        float f6 = f + 4.0f * f2 - 3.0f * f3;
        float f7 = f3 - f2;
        float_.x = (f4 * floatArray[n - 1].x + f5 * floatArray[n].x + f6 * floatArray[n + 1].x + f7 * floatArray[n + 2].x) / 2.0f;
        float_.y = (f4 * floatArray[n - 1].y + f5 * floatArray[n].y + f6 * floatArray[n + 1].y + f7 * floatArray[n + 2].y) / 2.0f;
    }
}

